/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.activehelp;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import javax.swing.CellRendererPane;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.activehelp.CloseIcon;
import oracle.install.commons.activehelp.CollapseIcon;
import oracle.install.commons.activehelp.ExpandIcon;
import oracle.install.commons.activehelp.HelpInfo;
import oracle.install.commons.activehelp.resource.StringResourceBundle;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

class Callout
extends JComponent {
    private static final Font DEFAULT_FONT = new Font("Tahoma", 0, 10);
    private static final int ICON_GAP = 2;
    private static final int NOTE_MORE_LINK_GAP = 2;
    private static final String DEFAULT_MORE_LINK_TEXT = "more";
    private static final Insets COLLAPSED_STATE_MARGIN = new Insets(5, 5, 7, 5);
    private static final Insets EXPANDED_STATE_MARGIN = new Insets(5, 5, 5, 5);
    private static final int MIN_EXPANDED_CALLOUT_HEIGHT = 108;
    private static final int MIN_CALLOUT_WIDTH = 200;
    private static final int MAX_CALLOUT_WIDTH = 300;
    private static final int MAX_EXPANDED_CALLOUT_HEIGHT = 168;
    private static final int SLOPE = 14;
    private static final int SHADOW_THICKNESS = 5;
    private static final int CURVE = 5;
    private static final short DISPLAY_STATE_EXPANDED = 1;
    private static final short DISPLAY_STATE_COLLAPSED = 2;
    private static final ImageIcon EXPAND_ICON = new ExpandIcon();
    private static final ImageIcon COLLAPSE_ICON = new CollapseIcon();
    private static final ImageIcon CLOSE_ICON = new CloseIcon();
    private static final short ORIENTATION_RIGHT_DOWN = 1;
    private static final short ORIENTATION_RIGHT_UP = 2;
    private static final short ORIENTATION_LEFT_UP = 3;
    private static final short ORIENTATION_LEFT_DOWN = 4;
    private short displayState;
    private Font conciseTextFont;
    private Font extendedTextFont;
    private Font moreLinkFont;
    private int calloutHeight;
    private int calloutWidth;
    private Rectangle paintArea;
    private Rectangle noteArea;
    private Rectangle conciseTextArea;
    private Rectangle extendedTextArea;
    private Rectangle moreLinkArea;
    private Rectangle disclosureIconArea;
    private Rectangle closeIconArea;
    private short orientation;
    private Point locationOffet;
    private RenderingHints renderHints;
    private boolean moreLinkActivated;
    private CellRendererPane cellRendererPane;
    private MultiLineLabel conciseTextRenderer;
    private MultiLineLabel extendedTextRenderer;
    private GeneralPath originalCalloutShape;
    private Shape calloutShape;
    private ImageIcon disclosureIcon;
    private ImageIcon closeIcon;
    private Color borderColor;
    private Color moreLinkColor;
    private Component referer;
    private float opacity;
    private boolean modified;
    private HelpInfo helpInfo;
    private String moreLinkText;
    private Insets margin;
    private Dimension size;
    private ComponentListener refererListener;

    public Callout() {
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.originalCalloutShape = new GeneralPath();
        this.cellRendererPane = new CellRendererPane();
        this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
        this.moreLinkText = resource.getString("Callout.MoreLinkText", DEFAULT_MORE_LINK_TEXT, new Object[0]);
        this.conciseTextRenderer = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.conciseTextRenderer.setOpaque(false);
        this.extendedTextRenderer = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.extendedTextRenderer.setOpaque(false);
        this.moreLinkColor = Color.blue;
        this.borderColor = Color.black;
        this.opacity = 1.0f;
        this.disclosureIcon = COLLAPSE_ICON;
        this.closeIcon = CLOSE_ICON;
        this.calloutWidth = 200;
        this.displayState = 1;
        this.size = new Dimension(this.calloutWidth + 5, 113);
        this.margin = COLLAPSED_STATE_MARGIN;
        this.paintArea = new Rectangle();
        this.noteArea = new Rectangle();
        this.conciseTextArea = new Rectangle();
        this.extendedTextArea = new Rectangle();
        this.moreLinkArea = new Rectangle();
        this.disclosureIconArea = new Rectangle();
        this.closeIconArea = new Rectangle();
        this.setOpaque(true);
        this.setBackground(new Color(255, 250, 194));
        Font font = DEFAULT_FONT;
        Locale locale = this.getLocale();
        if (locale != null) {
            String language = locale.getLanguage();
            if (!Locale.ENGLISH.getLanguage().equals(language)) {
                font = this.extendedTextRenderer.getFont();
                font = font.deriveFont((float)font.getSize() * 0.8f);
            }
        }
        this.setFont(font);
        this.refererListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Callout.this.close();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Callout.this.close();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Callout.this.close();
            }
        };
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){
            private boolean keyboardCollapseControlEnabled;

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (Callout.this.isShowing() && e.getID() == 402) {
                    if (e.getKeyCode() == 27) {
                        Callout.this.close();
                        e.consume();
                    } else if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 87 && Callout.this.isVisible()) {
                        this.keyboardCollapseControlEnabled = true;
                        e.consume();
                    } else if (Callout.this.isVisible() && this.keyboardCollapseControlEnabled && e.getKeyCode() == 10) {
                        Callout.this.toggleDisplayState();
                        e.consume();
                    }
                }
                return false;
            }
        });
        this.size = this.getSize();
        this.setBounds(0, 0, this.size.width, this.size.height);
        this.setLocation(0, 0);
        this.setOpacity(1.0f);
    }

    @Override
    public boolean contains(int x, int y) {
        Shape shape = this.calloutShape == null ? this.originalCalloutShape : this.calloutShape;
        return shape.contains(x, y);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.extendedTextFont = new Font(font.getFamily(), 0, font.getSize());
        this.extendedTextRenderer.setFont(this.extendedTextFont);
        this.conciseTextFont = new Font(font.getFamily(), 1, font.getSize());
        this.conciseTextRenderer.setFont(this.conciseTextFont);
        this.moreLinkFont = this.extendedTextFont;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        switch (id) {
            case 500: {
                Point point = e.getPoint();
                if (this.disclosureIconArea.contains(point)) {
                    this.toggleDisplayState();
                    e.consume();
                    break;
                }
                if (!this.closeIconArea.contains(point)) break;
                this.close();
                e.consume();
                break;
            }
            case 501: {
                if (this.moreLinkActivated) {
                    e.consume();
                }
                if (this.calloutShape.contains(e.getPoint())) {
                    e.consume();
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Callout.this.close();
                    }
                });
                break;
            }
            case 502: {
                if (!this.moreLinkActivated) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application application = Application.getInstance();
                        application.showHelpForComponent(Callout.this.getReferer());
                    }
                });
                e.consume();
            }
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            Point point = e.getPoint();
            this.moreLinkActivated = false;
            if (this.moreLinkArea.contains(point)) {
                this.moreLinkActivated = true;
                this.setCursor(Cursor.getPredefinedCursor(12));
                e.consume();
            } else if (this.closeIconArea.contains(point) || this.disclosureIconArea.contains(point)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                e.consume();
            } else if (this.getCursor().getType() != 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public int toggleDisplayState() {
        this.displayState = (short)(this.displayState == 1 ? 2 : 1);
        this.adjustPosition(null);
        this.clear();
        this.repaint();
        return this.displayState;
    }

    private void clear() {
        Container parent = this.getParent();
        if (parent != null) {
            Rectangle r = this.getBounds();
            parent.repaint(r.x, r.y, r.width, r.height);
        }
        this.revalidate();
    }

    public HelpInfo getHelpInfo() {
        return this.helpInfo;
    }

    public void setHelpInfo(HelpInfo helpInfo) {
        this.helpInfo = helpInfo;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size.height;
    }

    @Override
    public int getWidth() {
        return this.size.width;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public Component getReferer() {
        return this.referer;
    }

    public void setReferer(Component referer) {
        if (referer != null && this.referer != referer) {
            if (this.referer != null) {
                this.referer.removeComponentListener(this.refererListener);
            }
            this.referer = referer;
            this.referer.addComponentListener(this.refererListener);
            this.modified = true;
            this.adjustPosition(null);
        }
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private void translateTextArea(int x) {
        this.disclosureIconArea.x = this.paintArea.x = x + this.margin.left;
        this.noteArea.x = this.disclosureIconArea.x + this.disclosureIconArea.width + 2;
        this.closeIconArea.x = this.noteArea.x + this.noteArea.width + 2;
        this.conciseTextArea.x = this.noteArea.x;
        this.extendedTextArea.x = this.noteArea.x;
        this.moreLinkArea.x = this.noteArea.x;
    }

    private void rotate(short orientation) {
        this.orientation = orientation;
        switch (orientation) {
            case 1: {
                this.locationOffet = new Point(0, this.referer.getHeight());
                this.calloutShape = this.originalCalloutShape;
                this.translateTextArea(14);
                break;
            }
            case 2: {
                AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
                tx.translate(0.0, -this.calloutHeight);
                this.calloutShape = this.originalCalloutShape.createTransformedShape(tx);
                this.locationOffet = new Point(0, -(this.calloutHeight + 5 - 2));
                this.translateTextArea(14);
                break;
            }
            case 3: {
                AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(180.0));
                tx.translate(-this.calloutWidth, -this.calloutHeight);
                this.calloutShape = this.originalCalloutShape.createTransformedShape(tx);
                this.locationOffet = new Point(this.referer.getWidth() - (this.calloutWidth + 5 - 2), -(this.calloutHeight + 5 - 2));
                this.translateTextArea(0);
                break;
            }
            case 4: {
                AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(180.0));
                tx.scale(1.0, -1.0);
                tx.translate(-this.calloutWidth, 0.0);
                this.calloutShape = this.originalCalloutShape.createTransformedShape(tx);
                this.locationOffet = new Point(this.referer.getWidth() - (this.calloutWidth + 5 - 2), this.referer.getHeight());
                this.translateTextArea(0);
            }
        }
    }

    private void buildCalloutShape(Graphics2D g2) {
        Rectangle2D conciseTextBounds;
        if (this.displayState == 2) {
            this.margin = COLLAPSED_STATE_MARGIN;
            this.disclosureIcon = COLLAPSE_ICON;
        } else {
            this.disclosureIcon = EXPAND_ICON;
            this.margin = EXPANDED_STATE_MARGIN;
        }
        int maxNoteAreaWidth = 300 - this.disclosureIcon.getIconWidth() - this.closeIcon.getIconWidth() - 4 - 14 - this.margin.left - this.margin.right;
        this.paintArea.x = 14 + this.margin.left;
        this.paintArea.y = this.margin.top;
        this.paintArea.width = 186 - this.margin.left - this.margin.right;
        this.disclosureIconArea.x = this.paintArea.x;
        this.disclosureIconArea.y = this.paintArea.y;
        this.disclosureIconArea.width = this.disclosureIcon.getIconWidth();
        this.disclosureIconArea.height = this.disclosureIcon.getIconHeight();
        this.noteArea.x = this.disclosureIconArea.x + this.disclosureIconArea.width + 2;
        this.noteArea.y = this.paintArea.y;
        this.noteArea.width = this.paintArea.width - this.disclosureIcon.getIconWidth() - this.closeIcon.getIconWidth() - 4;
        this.conciseTextArea.x = this.noteArea.x;
        this.conciseTextArea.y = this.noteArea.y;
        this.conciseTextArea.width = this.noteArea.width;
        FontMetrics fontMetrics = this.getFontMetrics(this.conciseTextFont);
        this.conciseTextArea.height = fontMetrics.getHeight();
        String conciseText = this.helpInfo.getConciseText();
        if (conciseText != null && (conciseTextBounds = fontMetrics.getStringBounds(conciseText, g2)).getWidth() > this.conciseTextArea.getWidth()) {
            this.conciseTextArea.height *= 2;
            int requiredWidth = (int)(conciseTextBounds.getWidth() / 2.0);
            if ((double)(requiredWidth + requiredWidth / 10) > this.conciseTextArea.getWidth()) {
                this.conciseTextArea.width = requiredWidth + requiredWidth / 10 > maxNoteAreaWidth ? maxNoteAreaWidth : requiredWidth + requiredWidth / 10;
                this.paintArea.width = this.conciseTextArea.width + this.disclosureIcon.getIconWidth() + this.closeIcon.getIconWidth() + 4;
                this.noteArea.width = this.conciseTextArea.width;
            }
        }
        this.closeIconArea.x = this.noteArea.x + this.noteArea.width + 2;
        this.closeIconArea.y = this.paintArea.y;
        this.closeIconArea.width = this.closeIcon.getIconWidth();
        this.closeIconArea.height = this.closeIcon.getIconHeight();
        this.noteArea.height = this.paintArea.height = this.calloutHeight;
        switch (this.displayState) {
            case 2: {
                this.calloutHeight = this.conciseTextArea.height + this.margin.bottom + this.margin.top;
                break;
            }
            case 1: {
                this.paintArea.height = 108 - this.margin.top - this.margin.bottom;
                fontMetrics = this.getFontMetrics(this.moreLinkFont);
                this.moreLinkArea.x = this.noteArea.x;
                this.moreLinkArea.height = fontMetrics.getHeight();
                this.moreLinkArea.y = this.paintArea.y + this.paintArea.height - this.moreLinkArea.height;
                Rectangle2D moreLinkTextBounds = fontMetrics.getStringBounds(this.moreLinkText, g2);
                this.moreLinkArea.width = (int)moreLinkTextBounds.getWidth();
                this.extendedTextArea.x = this.noteArea.x;
                this.extendedTextArea.y = this.conciseTextArea.y + this.conciseTextArea.height;
                this.extendedTextArea.width = this.noteArea.width;
                this.extendedTextArea.height = this.paintArea.height - this.conciseTextArea.height;
                if (this.helpInfo.isMoreHelpAvailable()) {
                    this.extendedTextArea.height = this.extendedTextArea.height - 2 - this.moreLinkArea.height;
                } else {
                    this.moreLinkArea.height = 0;
                    this.moreLinkArea.width = 0;
                }
                this.calloutHeight = 108;
            }
        }
        this.calloutWidth = this.paintArea.width + 14 + this.margin.left + this.margin.right;
        this.originalCalloutShape.reset();
        int x0 = 0;
        int y0 = 0;
        int x = x0;
        int y = y0;
        this.originalCalloutShape.moveTo(x, y);
        this.originalCalloutShape.lineTo(x += 14, y += 14);
        this.originalCalloutShape.lineTo(x, y += this.calloutHeight - 14 - 1 - 5);
        int cx1 = x;
        int cy1 = y + 5;
        this.originalCalloutShape.quadTo(cx1, cy1, x += 5, y += 5);
        this.originalCalloutShape.lineTo(x += this.calloutWidth - 14 - 1 - 10, y);
        cx1 = x + 5;
        cy1 = y;
        this.originalCalloutShape.quadTo(cx1, cy1, x += 5, y -= 5);
        this.originalCalloutShape.lineTo(x, y -= this.calloutHeight - 1 - 10);
        cx1 = x;
        cy1 = y - 5;
        this.originalCalloutShape.quadTo(cx1, cy1, x -= 5, y -= 5);
        this.originalCalloutShape.lineTo(x -= this.calloutWidth - 1 - 5, y);
        this.originalCalloutShape.closePath();
        this.size.width = this.calloutWidth + 5;
        this.size.height = this.calloutHeight + 5;
        super.setSize(this.size);
    }

    private void adjustPosition(Graphics2D g2) throws IllegalComponentStateException {
        if (this.referer != null) {
            this.buildCalloutShape(g2);
            Point location = this.referer.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(location, this.getParent());
            Component root = SwingUtilities.getRoot(this.referer);
            Rectangle windowRect = new Rectangle(root.getSize());
            if (root instanceof Window) {
                Insets windowInsets = ((Window)root).getInsets();
                windowRect.width -= windowInsets.left + windowInsets.right;
                windowRect.height -= windowInsets.top + windowInsets.bottom;
            }
            int refererWidth = this.referer.getWidth();
            int refererHeight = this.referer.getHeight();
            int calloutOrientation = 1;
            Point corner = new Point(location.x + this.size.width, location.y + this.size.height + refererHeight);
            if (windowRect.contains(corner)) {
                calloutOrientation = 1;
            } else {
                corner.y = location.y - this.size.height;
                if (windowRect.contains(corner)) {
                    calloutOrientation = 2;
                } else {
                    corner.x = location.x - this.size.width;
                    if (windowRect.contains(corner)) {
                        calloutOrientation = 3;
                    } else {
                        corner.y = location.y + this.size.height + refererHeight;
                        if (windowRect.contains(corner)) {
                            calloutOrientation = 4;
                        }
                    }
                }
            }
            this.rotate((short)calloutOrientation);
            if (this.locationOffet != null) {
                location.translate(this.locationOffet.x, this.locationOffet.y);
                this.setLocation(location);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        try {
            this.adjustPosition(g2);
            g2.setRenderingHints(this.renderHints);
            g2.setComposite(this.makeComposite(this.opacity));
            Color oldColor = g2.getColor();
            AffineTransform transform = AffineTransform.getTranslateInstance(5.0, 5.0);
            g2.transform(transform);
            transform = AffineTransform.getTranslateInstance(-1.0, -1.0);
            Composite originalComposite = g2.getComposite();
            for (int i = 0; i < 5; ++i) {
                g2.setComposite(this.makeComposite((float)i * 0.1f * this.opacity));
                g2.setPaint(Color.gray);
                g2.draw(this.calloutShape);
                g2.transform(transform);
            }
            g2.setComposite(originalComposite);
            g2.setColor(this.getBackground());
            g2.fill(this.calloutShape);
            g2.setColor(this.borderColor);
            g2.draw(this.calloutShape);
            this.disclosureIcon.paintIcon(this, g2, this.disclosureIconArea.x, this.disclosureIconArea.y);
            this.closeIcon.paintIcon(this, g2, this.closeIconArea.x, this.closeIconArea.y);
            g2.setColor(oldColor);
            String conciseText = this.helpInfo.getConciseText();
            this.conciseTextRenderer.setText(conciseText);
            this.cellRendererPane.paintComponent(g2, (Component)this.conciseTextRenderer, this, this.conciseTextArea);
            if (this.displayState == 1) {
                this.extendedTextRenderer.setText(this.helpInfo.getExtendedText());
                this.cellRendererPane.paintComponent(g2, (Component)this.extendedTextRenderer, this, this.extendedTextArea);
                if (this.helpInfo.isMoreHelpAvailable()) {
                    g2.setColor(this.moreLinkColor);
                    g2.setFont(this.moreLinkFont);
                    int y = this.moreLinkArea.y + 3 * this.moreLinkArea.height / 4;
                    g2.drawString(this.moreLinkText, this.moreLinkArea.x, y);
                    g2.drawLine(this.moreLinkArea.x, ++y, this.moreLinkArea.x + this.moreLinkArea.width, y);
                }
            }
        }
        catch (IllegalComponentStateException e) {
            this.close();
        }
    }

    public String getMoreLinkText() {
        return this.moreLinkText;
    }

    public void setMoreLinkText(String moreLinkText) {
        this.moreLinkText = moreLinkText;
    }

    public void close() {
        if (this.referer != null) {
            this.referer.removeComponentListener(this.refererListener);
        }
        this.referer = null;
        this.setVisible(false);
    }
}

